<?php
/**
 * ملف الاتصال بقاعدة البيانات باستخدام PDO.
 */

$config = require __DIR__ . '/config.php';

if (!is_dir($config['storage_dir'])) {
    mkdir($config['storage_dir'], 0775, true);
}

date_default_timezone_set($config['timezone'] ?? 'UTC');

function db()
{
    static $pdo = null;

    if ($pdo === null) {
        $config = require __DIR__ . '/config.php';
        $db = $config['db'];

        $dsn = "mysql:host={$db['host']};dbname={$db['name']};charset={$db['charset']}";
        try {
            $pdo = new PDO($dsn, $db['user'], $db['pass'], [
                PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES   => false,
            ]);
        } catch (PDOException $e) {
            error_log("DB Connection failed: " . $e->getMessage());
            die("Database connection error");
        }
    }

    return $pdo;
}

/**
 * دوال مساعدة عامة
 */
function app_log_error($message)
{
    $config = require __DIR__ . '/config.php';
    $line = '[' . date('Y-m-d H:i:s') . '] ' . $message . PHP_EOL;
    file_put_contents($config['error_log'], $line, FILE_APPEND);
}

/**
 * قراءة إعداد من جدول settings
 */
function get_setting($key, $default = null)
{
    $pdo = db();
    $stmt = $pdo->prepare("SELECT value FROM settings WHERE `key` = ? LIMIT 1");
    $stmt->execute([$key]);
    $row = $stmt->fetch();
    if ($row) {
        return $row['value'];
    }
    return $default;
}

/**
 * حفظ إعداد في جدول settings
 */
function set_setting($key, $value)
{
    $pdo = db();
    $stmt = $pdo->prepare("INSERT INTO settings (`key`, `value`) VALUES(?, ?)
                           ON DUPLICATE KEY UPDATE `value` = VALUES(`value`)");
    $stmt->execute([$key, $value]);
}
