<?php
/**
 * نظام بسيط لإدارة المستخدمين والجلسات (يوزر/باسورد + صلاحيات).
 */

require_once __DIR__ . '/db.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/**
 * تهيئة أول مستخدم (admin) في حال لم يوجد أي مستخدم
 */
function ensure_initial_admin()
{
    $config = require __DIR__ . '/config.php';
    $pdo = db();

    $count = $pdo->query("SELECT COUNT(*) AS c FROM users")->fetchColumn();
    if ($count == 0) {
        $username = $config['initial_admin']['username'];
        $password = $config['initial_admin']['password'];
        $hash = password_hash($password, PASSWORD_BCRYPT);

        $stmt = $pdo->prepare("INSERT INTO users (username, password_hash, role, is_active, created_at, updated_at)
                               VALUES (?, ?, 'admin', 1, NOW(), NOW())");
        $stmt->execute([$username, $hash]);
    }
}

/**
 * تسجيل الدخول
 */
function login($username, $password)
{
    $pdo = db();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? AND is_active = 1 LIMIT 1");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['yt2tg_user'] = [
            'id'       => $user['id'],
            'username' => $user['username'],
            'role'     => $user['role'],
        ];
        return true;
    }

    return false;
}

/**
 * تسجيل الخروج
 */
function logout()
{
    unset($_SESSION['yt2tg_user']);
}

/**
 * استرجاع المستخدم الحالي
 */
function current_user()
{
    return $_SESSION['yt2tg_user'] ?? null;
}

/**
 * التحقق من تسجيل الدخول
 */
function require_login()
{
    if (!current_user()) {
        header("Location: login.php");
        exit;
    }
}

/**
 * التحقق من صلاحية معينة (role)
 * الأدوار: admin, editor, viewer
 */
function require_role($role)
{
    $user = current_user();
    if (!$user) {
        header("Location: login.php");
        exit;
    }

    $rolesHierarchy = [
        'viewer' => 1,
        'editor' => 2,
        'admin'  => 3,
    ];

    $userLevel = $rolesHierarchy[$user['role']] ?? 0;
    $requiredLevel = $rolesHierarchy[$role] ?? 999;

    if ($userLevel < $requiredLevel) {
        die("لا تملك صلاحية الوصول إلى هذه الصفحة.");
    }
}
