<?php
require_once __DIR__ . '/../auth.php';

// إنشاء أول مستخدم (admin) لو لم يوجد أحد
ensure_initial_admin();

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    if (login($username, $password)) {
        header("Location: index.php");
        exit;
    } else {
        $error = 'بيانات الدخول غير صحيحة.';
    }
}

?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>تسجيل الدخول - لوحة إدارة YouTube → Telegram</title>
    <style>
        body { font-family: sans-serif; background:#f5f5f5; display:flex; align-items:center; justify-content:center; height:100vh; }
        .login-box { background:#fff; padding:20px 25px; border-radius:6px; box-shadow:0 0 10px rgba(0,0,0,0.1); width:320px; }
        .login-box h1 { font-size:18px; margin-bottom:15px; }
        .login-box input[type="text"], .login-box input[type="password"] { width:100%; padding:8px; margin-bottom:10px; box-sizing:border-box; }
        .login-box input[type="submit"] { padding:8px 16px; }
        .error { color:red; margin-bottom:10px; }
        .hint { font-size:12px; color:#555; margin-top:10px; }
    </style>
</head>
<body>
<div class="login-box">
    <h1>لوحة إدارة YouTube → Telegram</h1>
    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error, ENT_QUOTES, 'UTF-8') ?></div>
    <?php endif; ?>
    <form method="post">
        <label>اسم المستخدم:</label><br>
        <input type="text" name="username" required><br>
        <label>كلمة المرور:</label><br>
        <input type="password" name="password" required><br>
        <input type="submit" value="دخول">
    </form>
    <div class="hint">
        في أول تشغيل، يتم إنشاء مستخدم مدير تلقائياً إذا لم يوجد مستخدمون.<br>
        راجع ملف <code>config.php</code> لقيم المستخدم الافتراضي.
    </div>
</div>
</body>
</html>
