<?php
require_once __DIR__ . '/../auth.php';
require_login();

$user = current_user();
$pdo  = db();

// تحميل الإعدادات
$settingsKeys = [
    'telegram_bot_token',
    'telegram_chat_id',
    'min_interval_seconds',
    'max_videos_per_run_per_channel',
];

$settings = [];
foreach ($settingsKeys as $k) {
    $settings[$k] = get_setting($k, '');
}

// تحميل القنوات
$channelsStmt = $pdo->query("SELECT * FROM channels ORDER BY id ASC");
$channels = $channelsStmt->fetchAll();

// تحميل المستخدمين (للمدير فقط)
$users = [];
if ($user['role'] === 'admin') {
    $usersStmt = $pdo->query("SELECT id, username, role, is_active, created_at FROM users ORDER BY id ASC");
    $users = $usersStmt->fetchAll();
}

$saveMessage = '';

// معالجة الحفظ
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // حفظ الإعدادات - admin فقط
    if ($user['role'] === 'admin') {
        foreach ($settingsKeys as $k) {
            $val = trim($_POST[$k] ?? '');
            if (in_array($k, ['min_interval_seconds', 'max_videos_per_run_per_channel'])) {
                $val = (string)max(0, (int)$val);
            }
            set_setting($k, $val);
            $settings[$k] = $val;
        }
    }

    // حفظ القنوات - admin أو editor
    if (in_array($user['role'], ['admin', 'editor'], true)) {
        // حذف كل القنوات وإعادة إدخالها بناءً على الفورم (بسيط وواضح)
        $pdo->exec("DELETE FROM channels");
        if (!empty($_POST['channels']) && is_array($_POST['channels'])) {
            $insertStmt = $pdo->prepare("INSERT INTO channels (title, youtube_channel_url, youtube_feed_url, enabled, created_at, updated_at)
                                         VALUES (?, ?, ?, ?, NOW(), NOW())");
            foreach ($_POST['channels'] as $row) {
                $title  = trim($row['title'] ?? '');
                $url    = trim($row['youtube_channel_url'] ?? '');
                $feed   = trim($row['youtube_feed_url'] ?? '');
                $enabled = isset($row['enabled']) ? 1 : 0;

                if ($title === '' && $url === '' && $feed === '') {
                    continue;
                }

                $insertStmt->execute([
                    $title ?: 'قناة بدون اسم',
                    $url,
                    $feed,
                    $enabled,
                ]);
            }
        }

        // إعادة تحميل القنوات بعد الحفظ
        $channelsStmt = $pdo->query("SELECT * FROM channels ORDER BY id ASC");
        $channels = $channelsStmt->fetchAll();
    }

    // إدارة المستخدمين - admin فقط
    if ($user['role'] === 'admin' && isset($_POST['users']) && is_array($_POST['users'])) {
        foreach ($_POST['users'] as $uRow) {
            $id       = isset($uRow['id']) ? (int)$uRow['id'] : 0;
            $username = trim($uRow['username'] ?? '');
            $role     = $uRow['role'] ?? 'viewer';
            $isActive = isset($uRow['is_active']) ? 1 : 0;
            $password = trim($uRow['password'] ?? '');

            if ($id > 0) {
                // تحديث مستخدم موجود
                if ($password !== '') {
                    $hash = password_hash($password, PASSWORD_BCRYPT);
                    $stmt = $pdo->prepare("UPDATE users SET username = ?, role = ?, is_active = ?, password_hash = ?, updated_at = NOW() WHERE id = ?");
                    $stmt->execute([$username, $role, $isActive, $hash, $id]);
                } else {
                    $stmt = $pdo->prepare("UPDATE users SET username = ?, role = ?, is_active = ?, updated_at = NOW() WHERE id = ?");
                    $stmt->execute([$username, $role, $isActive, $id]);
                }
            } else {
                // مستخدم جديد
                if ($username !== '' && $password !== '') {
                    $hash = password_hash($password, PASSWORD_BCRYPT);
                    $stmt = $pdo->prepare("INSERT INTO users (username, password_hash, role, is_active, created_at, updated_at)
                                           VALUES (?, ?, ?, ?, NOW(), NOW())");
                    $stmt->execute([$username, $hash, $role, $isActive]);
                }
            }
        }

        // إعادة تحميل المستخدمين
        $usersStmt = $pdo->query("SELECT id, username, role, is_active, created_at FROM users ORDER BY id ASC");
        $users = $usersStmt->fetchAll();
    }

    $saveMessage = 'تم حفظ التعديلات بنجاح.';
}

?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="utf-8">
    <title>لوحة إدارة YouTube → Telegram</title>
    <style>
        body { font-family: sans-serif; background:#f5f5f5; margin:0; padding:0; }
        .container { max-width: 1200px; margin:30px auto; background:#fff; padding:20px 25px; border-radius:6px; box-shadow:0 0 10px rgba(0,0,0,0.05); }
        h1 { font-size:22px; margin-bottom:10px; }
        h2 { font-size:18px; margin-top:25px; }
        label { font-size:14px; display:block; margin-top:8px; }
        input[type="text"], input[type="number"], input[type="password"] { width:100%; padding:6px 8px; margin-top:3px; box-sizing:border-box; }
        table { width:100%; border-collapse: collapse; margin-top:10px; }
        th, td { border:1px solid #ddd; padding:6px; font-size:13px; vertical-align: top; }
        th { background:#f0f0f0; }
        .btn { padding:6px 12px; font-size:13px; cursor:pointer; }
        .btn-primary { background:#007bff; color:#fff; border:1px solid #007bff; }
        .btn-secondary { background:#6c757d; color:#fff; border:1px solid #6c757d; }
        .top-bar { display:flex; justify-content:space-between; align-items:center; margin-bottom:15px; }
        .message { color:green; margin-bottom:10px; }
        .user-info { font-size:13px; color:#555; }
        .tab-nav { margin-top:10px; margin-bottom:15px; }
        .tab-nav button { margin-left:5px; }
        .tab-content { display:none; }
        .tab-content.active { display:block; }
    </style>
</head>
<body>
<div class="container">
    <div class="top-bar">
        <div>
            <h1>لوحة إدارة YouTube → Telegram</h1>
            <div class="user-info">
                مرحباً، <?= htmlspecialchars($user['username'], ENT_QUOTES, 'UTF-8') ?> (الصلاحية: <?= htmlspecialchars($user['role'], ENT_QUOTES, 'UTF-8') ?>)
            </div>
        </div>
        <div>
            <a href="logout.php">تسجيل الخروج</a>
        </div>
    </div>

    <?php if ($saveMessage): ?>
        <div class="message"><?= htmlspecialchars($saveMessage, ENT_QUOTES, 'UTF-8') ?></div>
    <?php endif; ?>

    <div class="tab-nav">
        <button type="button" class="btn btn-secondary" onclick="showTab('tab-settings')">الإعدادات العامة</button>
        <button type="button" class="btn btn-secondary" onclick="showTab('tab-channels')">قنوات يوتيوب</button>
        <?php if ($user['role'] === 'admin'): ?>
        <button type="button" class="btn btn-secondary" onclick="showTab('tab-users')">المستخدمون</button>
        <?php endif; ?>
    </div>

    <form method="post">
        <!-- تبويب الإعدادات -->
        <div id="tab-settings" class="tab-content active">
            <h2>الإعدادات العامة (تليجرام والفترات الزمنية)</h2>
            <?php if ($user['role'] !== 'admin'): ?>
                <p style="color:#a00; font-size:13px;">فقط المدير يمكنه تعديل هذه الإعدادات.</p>
            <?php endif; ?>

            <label>Telegram Bot Token:</label>
            <input type="text" name="telegram_bot_token"
                   value="<?= htmlspecialchars($settings['telegram_bot_token'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
                   <?= $user['role'] !== 'admin' ? 'readonly' : '' ?>>

            <label>Telegram Chat ID (مثال: @channel_username أو ID رقمي):</label>
            <input type="text" name="telegram_chat_id"
                   value="<?= htmlspecialchars($settings['telegram_chat_id'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
                   <?= $user['role'] !== 'admin' ? 'readonly' : '' ?>>

            <label>الفاصل الزمني الأدنى بين التشغيلات (بالثواني):</label>
            <input type="number" name="min_interval_seconds" min="0"
                   value="<?= (int)($settings['min_interval_seconds'] ?? 900) ?>"
                   <?= $user['role'] !== 'admin' ? 'readonly' : '' ?>>

            <label>أقصى عدد فيديوهات لكل قناة في كل تشغيل:</label>
            <input type="number" name="max_videos_per_run_per_channel" min="1"
                   value="<?= (int)($settings['max_videos_per_run_per_channel'] ?? 3) ?>"
                   <?= $user['role'] !== 'admin' ? 'readonly' : '' ?>>
        </div>

        <!-- تبويب القنوات -->
        <div id="tab-channels" class="tab-content">
            <h2>قنوات يوتيوب</h2>
            <?php if (!in_array($user['role'], ['admin', 'editor'], true)): ?>
                <p style="color:#a00; font-size:13px;">فقط المدير أو المحرر يمكنهما تعديل القنوات.</p>
            <?php endif; ?>

            <p style="font-size:13px;">
                يمكنك وضع رابط القناة (من نوع <code>/channel/UCxxx</code>) في خانة "رابط القناة"،
                وسيتم توليد رابط الـ RSS تلقائيًا داخل سكربت الكرون إذا لم تُحدد "رابط الـ feed".<br>
                أو يمكنك وضع رابط الـ RSS مباشرة في خانة "رابط الـ feed" (مثال:
                <code>https://www.youtube.com/feeds/videos.xml?channel_id=UCxxxx</code>).
            </p>

            <table>
                <thead>
                <tr>
                    <th>اسم القناة</th>
                    <th>رابط القناة على يوتيوب</th>
                    <th>رابط الـ RSS feed</th>
                    <th>مفعّلة؟</th>
                </tr>
                </thead>
                <tbody id="channels-rows">
                <?php if (!empty($channels)): ?>
                    <?php foreach ($channels as $index => $ch): ?>
                        <tr>
                            <td>
                                <input type="text" name="channels[<?= $index ?>][title]"
                                       value="<?= htmlspecialchars($ch['title'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
                                       <?= !in_array($user['role'], ['admin', 'editor'], true) ? 'readonly' : '' ?>>
                            </td>
                            <td>
                                <input type="text" name="channels[<?= $index ?>][youtube_channel_url]"
                                       value="<?= htmlspecialchars($ch['youtube_channel_url'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
                                       <?= !in_array($user['role'], ['admin', 'editor'], true) ? 'readonly' : '' ?>>
                            </td>
                            <td>
                                <input type="text" name="channels[<?= $index ?>][youtube_feed_url]"
                                       value="<?= htmlspecialchars($ch['youtube_feed_url'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
                                       <?= !in_array($user['role'], ['admin', 'editor'], true) ? 'readonly' : '' ?>>
                            </td>
                            <td style="text-align:center;">
                                <input type="checkbox" name="channels[<?= $index ?>][enabled]" value="1"
                                       <?= $ch['enabled'] ? 'checked' : '' ?>
                                       <?= !in_array($user['role'], ['admin', 'editor'], true) ? 'disabled' : '' ?>>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td><input type="text" name="channels[0][title]" value="قناة رئيسية"></td>
                        <td><input type="text" name="channels[0][youtube_channel_url]" value=""></td>
                        <td><input type="text" name="channels[0][youtube_feed_url]" value=""></td>
                        <td style="text-align:center;"><input type="checkbox" name="channels[0][enabled]" value="1" checked></td>
                    </tr>
                <?php endif; ?>
                </tbody>
            </table>

            <?php if (in_array($user['role'], ['admin', 'editor'], true)): ?>
                <div style="margin-top:10px;">
                    <button type="button" class="btn btn-secondary" onclick="addChannelRow()">إضافة قناة جديدة</button>
                </div>
            <?php endif; ?>
        </div>

        <!-- تبويب المستخدمين -->
        <?php if ($user['role'] === 'admin'): ?>
        <div id="tab-users" class="tab-content">
            <h2>إدارة المستخدمين</h2>
            <p style="font-size:13px;">
                الأدوار المتاحة:
                <strong>admin</strong> (مدير) – صلاحيات كاملة.<br>
                <strong>editor</strong> (محرر) – إدارة القنوات فقط.<br>
                <strong>viewer</strong> (مشاهد) – عرض فقط بدون تعديل.
            </p>

            <table>
                <thead>
                <tr>
                    <th>ID</th>
                    <th>اسم المستخدم</th>
                    <th>الدور (role)</th>
                    <th>نشط؟</th>
                    <th>كلمة المرور (اتركها فارغة لعدم التغيير)</th>
                    <th>تاريخ الإنشاء</th>
                </tr>
                </thead>
                <tbody id="users-rows">
                <?php if (!empty($users)): ?>
                    <?php foreach ($users as $uIndex => $u): ?>
                        <tr>
                            <td>
                                <?= (int)$u['id'] ?>
                                <input type="hidden" name="users[<?= $uIndex ?>][id]" value="<?= (int)$u['id'] ?>">
                            </td>
                            <td><input type="text" name="users[<?= $uIndex ?>][username]"
                                       value="<?= htmlspecialchars($u['username'], ENT_QUOTES, 'UTF-8') ?>"></td>
                            <td>
                                <select name="users[<?= $uIndex ?>][role]">
                                    <?php foreach (['admin', 'editor', 'viewer'] as $r): ?>
                                        <option value="<?= $r ?>" <?= $u['role'] === $r ? 'selected' : '' ?>><?= $r ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </td>
                            <td style="text-align:center;">
                                <input type="checkbox" name="users[<?= $uIndex ?>][is_active]" value="1"
                                       <?= $u['is_active'] ? 'checked' : '' ?>>
                            </td>
                            <td>
                                <input type="password" name="users[<?= $uIndex ?>][password]" value="" placeholder="••••••••">
                            </td>
                            <td><?= htmlspecialchars($u['created_at'], ENT_QUOTES, 'UTF-8') ?></td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>

                <!-- صف جديد لإضافة مستخدم -->
                <tr>
                    <td>جديد</td>
                    <td><input type="text" name="users[new][username]" value=""></td>
                    <td>
                        <select name="users[new][role]">
                            <option value="viewer">viewer</option>
                            <option value="editor">editor</option>
                            <option value="admin">admin</option>
                        </select>
                    </td>
                    <td style="text-align:center;"><input type="checkbox" name="users[new][is_active]" value="1" checked></td>
                    <td><input type="password" name="users[new][password]" value="" placeholder="كلمة المرور الجديدة"></td>
                    <td>-</td>
                </tr>
                </tbody>
            </table>
        </div>
        <?php endif; ?>

        <br>
        <input type="submit" class="btn btn-primary" value="حفظ التعديلات">
    </form>
</div>

<script>
    function showTab(id) {
        var tabs = document.querySelectorAll('.tab-content');
        tabs.forEach(function (el) {
            el.classList.remove('active');
        });
        var active = document.getElementById(id);
        if (active) active.classList.add('active');
    }

    function addChannelRow() {
        var tbody = document.getElementById('channels-rows');
        var index = tbody.getElementsByTagName('tr').length;
        var tr = document.createElement('tr');
        tr.innerHTML =
            '<td><input type="text" name="channels[' + index + '][title]" value="قناة جديدة"></td>' +
            '<td><input type="text" name="channels[' + index + '][youtube_channel_url]" value=""></td>' +
            '<td><input type="text" name="channels[' + index + '][youtube_feed_url]" value=""></td>' +
            '<td style="text-align:center;"><input type="checkbox" name="channels[' + index + '][enabled]" value="1" checked></td>';
        tbody.appendChild(tr);
    }
</script>
</body>
</html>
